# define VERSION "1.56"


# define D_16384 23296     /// DISK_BUFFER_ADDR
# define D_49152 16384     /// SCREEN_START_ADDR

# define MAX_FILES 320
# define MAX_FILELEN 16384
# define MAX_DEPTH 10

# define start_l 8
# define num_l 16
# define num_c 3

# define NUM_PLAYERS 9

# define BLACK 0
# define BLUE 1
# define RED 2
# define MAGENTA 3
# define GREEN 4
# define CYAN 5
# define YELLOW 6
# define WHITE 7

# include <stdarg.h>

# define bool unsigned char
# define true 1
# define false 0



typedef struct 
{     
    int err;
	unsigned char * module;
	void * data;
	unsigned int Length;
	char Name[33];
	char Autor[33];
	char player[21];
	unsigned int counter;
	unsigned char detected;
	unsigned char play;
	unsigned int len;
	char filename[8];
	unsigned char slow;
	unsigned int pos;
	unsigned char variant;
	     
} AYSongInfo;

typedef struct
{
        char flip_flop_p;
		signed char play_mode;
        signed char current_player;
        char dntcounter;
        int tek_file;
        char depth;               
} vars_t;


enum
{
    AY_CHNL_A_FINE = 0,
    AY_CHNL_A_COARSE,
    AY_CHNL_B_FINE,
    AY_CHNL_B_COARSE,
    AY_CHNL_C_FINE,
    AY_CHNL_C_COARSE,
    AY_NOISE_PERIOD,
    AY_MIXER,
    AY_CHNL_A_VOL,
    AY_CHNL_B_VOL,
    AY_CHNL_C_VOL,
    AY_ENV_FINE,
    AY_ENV_COARSE,
    AY_ENV_SHAPE,
    AY_GPIO_A,
    AY_GPIO_B
};


void delay (unsigned int arg);
void Getnfiles(void);
void ClearString(char * name, int len);
void dstatus(void);
void ClearList(void);
void clearstring(char r);
void DiskErrMesage(char m, int m1);
void Status(char * s, int, int, int good);
void init (void);
void info (void);
void detect(void);
void sort(void);
void re(void);
void back (void);
void l(void);
void len(AYSongInfo * ss);
void title (int second);
void next (void);
void stop (void);
void resume (void);
void curcor (int plus);
void read_d(char d, char second);
void o (void);
void Shuffle(void);
int  play (int num);
char * d2s(unsigned char v);
void Copy_s(AYSongInfo *, vars_t *);
void clock (void);

void Counters(void);
void FN(AYSongInfo * info);

unsigned long PT3_GetTime(unsigned char *module, unsigned long * Loop);

extern void attr_too_old(void);
extern void bzero(char *, int);
extern void bzero1(void);
extern void printstring(unsigned int, char *);
extern void printstring1(unsigned int, char *);
extern void space_buf0(char);
extern void space_buf1(int, int);
extern void space_buf2(int, int);
extern void push_all(void);
extern void pop_all(void);
extern void seg_init(void);
extern unsigned char get_r(void);
extern void Pr_Sym(unsigned int XY, char Y);
extern unsigned char input (unsigned int);
extern void vg_drv_init(void);
extern void vg_select_drive(char);
extern void vg_read_sector1(unsigned int, unsigned int);
extern int vg_read_sector2(unsigned int, unsigned int);
extern void vg_init_drive (char);
void di_(void);
void ei_(void);
extern void output (unsigned int, char);
extern void decode_lzss_step(void *);

extern unsigned int PSG1000_play(unsigned int);
unsigned int PSG2000_play(unsigned int);
extern void move1(void);
extern void move2(void);

unsigned long int ay_sys_getword(unsigned char *p);
void ay_sys_writeword(unsigned char *p, unsigned int val);
void ay_writeay(unsigned char reg, unsigned char val);
char ay_readay(unsigned char reg);


void *memset(void *dst, int c, unsigned int n);
unsigned int strlen(char * str);
char * strncpy(char *s1,  char *s2, size_t n);
int strncmp( char *s1,  char *s2, size_t n);
char * strcpy(char *s1,  char *s2);
void* memcpy(void* dest,  void* src, size_t count);
int strcmp(const char *s1, const char *s2);
int memcmp(void * s1, void * s2, size_t n);
char *strcat(char *str1, char *str2);
int abs(int value);
int rand(void);
void Randomize(void);
int sprintf(char *out, const char *format, ...);
char putchar (char);
int printf(const char *format, ...);

int print(char **out, const char *format, va_list args);

void gotoxy(char x, char y);
void attr_new(char x, char y, char f, char t, char bright, char flash);
void ClearScreen(void);
void attr_old (unsigned int from, unsigned int len, unsigned char attr);
void tiho (void);
void FillList(void);

# define PAD_RIGHT 1
# define PAD_ZERO 2
# define PRINT_BUF_LEN 12

void PT1_Init(AYSongInfo * info);
bool PT1_Detect(unsigned char * module, unsigned int length, AYSongInfo * info);
void PT1_GetInfo(AYSongInfo * info);
void PT1_Play(AYSongInfo * info);

void PT2_Init(AYSongInfo * info);
bool PT2_Detect(unsigned char * module, unsigned int length, AYSongInfo * info);
void PT2_GetInfo(AYSongInfo * info);
void PT2_Play(AYSongInfo * info);

void PT3_Init(AYSongInfo * info);
bool PT3_Detect(unsigned char * module, unsigned int length, AYSongInfo * info);
void PT3_GetInfo(AYSongInfo * info);
void PT3_Play(AYSongInfo * info);

void STP_Init(AYSongInfo * info);
bool STP_Detect(unsigned char * module, unsigned int length, AYSongInfo * info);
void STP_GetInfo(AYSongInfo * info);
void STP_Play(AYSongInfo * info);

void ASC_Init(AYSongInfo * info);
bool ASC_Detect(unsigned char * module, unsigned int length, AYSongInfo * info);
void ASC_GetInfo(AYSongInfo * info);
void ASC_Play(AYSongInfo * info);

void PSC_Init(AYSongInfo * info);
bool PSC_Detect(unsigned char * module, unsigned int length, AYSongInfo * info);
void PSC_GetInfo(AYSongInfo * info);
void PSC_Play(AYSongInfo * info);

void STC_Init(AYSongInfo * info);
bool STC_Detect(unsigned char * module, unsigned int length, AYSongInfo * info);
void STC_GetInfo(AYSongInfo * info);
void STC_Play(AYSongInfo * info);

void SQT_Init(AYSongInfo * info);
bool SQT_Detect(unsigned char * module, unsigned int length, AYSongInfo * info);
void SQT_GetInfo(AYSongInfo * info);
void SQT_Play(AYSongInfo * info);

void PSG_Init(AYSongInfo * info);
bool PSG_Detect(unsigned char * module,  AYSongInfo * info);
void PSG_GetInfo(AYSongInfo * info);
void PSG_Play(AYSongInfo * info);


#define PT3_PatternsPointer (header->PT3_PatternsPointer0 | (header->PT3_PatternsPointer1 << 8))
#define PT3_SamplesPointers(x) (header->PT3_SamplesPointers0 [(x) * 2] | (header->PT3_SamplesPointers0 [(x) * 2 + 1] << 8))
#define PT3_OrnamentsPointers(x) (header->PT3_OrnamentsPointers0 [(x) * 2] | (header->PT3_OrnamentsPointers0 [(x) * 2 + 1] << 8))


typedef struct 
{
    signed char PT3_MusicName[0x63];
    unsigned char PT3_TonTableId;
    unsigned char PT3_Delay;
    unsigned char PT3_NumberOfPositions;
    unsigned char PT3_LoopPosition;
    unsigned char PT3_PatternsPointer0, PT3_PatternsPointer1;
    unsigned char PT3_SamplesPointers0[64];
    unsigned char PT3_OrnamentsPointers0[32];
    unsigned char PT3_PositionList[];
} PT3_File;





